VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 3  'UsesTransaction
END
Attribute VB_Name = "LogFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

   Public Enum e_ErrorLevels
     Informational = 4
     Warning = 2
     Error = 1
   End Enum
   Private Const m_cstrDatabasePath As String = "C:\VB Proj Man\Error Log\log.mdb"
   Private m_objADOConnection As ADODB.Connection
   Private m_objContext As ObjectContext
   Private Const m_cDateField As String = "DateLogged"
   Private Const m_cMessageField As String = "Message"
   Private Const m_cLevelField As String = "Level"
   Private Const m_cMethodPropertyField As String = "MethodProperty"
   Private Const m_cClassField As String = "Class"
   Private Const m_cApplicationField As String = "Application"
   Implements ObjectControl

Private Sub ObjectControl_Activate()
   Set m_objContext = GetObjectContext
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
   ObjectControl_CanBePooled = False
End Function

Private Sub ObjectControl_Deactivate()
   Set m_objADOConnection = Nothing
   Set m_objContext = Nothing
End Sub

Public Function WriteToDatabase(ByVal v_sAppName, ByVal v_sClass, _
                ByVal v_sMethodProperty, ByVal v_sMessage As String, _
                ByVal v_eLevel As e_ErrorLevels) As String
   Dim recLogRS As ADODB.Recordset
   On Error GoTo WriteToDatabaseError
   SetADOConnection "", ""
   Set recLogRS = New ADODB.Recordset
   recLogRS.CursorLocation = adUseServer
   recLogRS.CursorType = adOpenDynamic
   recLogRS.LockType = adLockPessimistic
   If v_eLevel = Informational Then
     recLogRS.Source = "ApplicationLog"
   Else
     recLogRS.Source = "ErrorLog"
   End If
   Set recLogRS.ActiveConnection = GetADOConnection
   recLogRS.Open
   recLogRS.AddNew
   recLogRS.Fields(m_cApplicationField) = v_sAppName
   recLogRS.Fields(m_cClassField) = v_sClass
   recLogRS.Fields(m_cDateField) = Now
   recLogRS.Fields(m_cLevelField) = v_eLevel
   recLogRS.Fields(m_cMessageField) = v_sMessage
   recLogRS.Fields(m_cMethodPropertyField) = v_sMethodProperty
   recLogRS.Update
ExitWriteToDatabase:
   CloseADOConnection
   Exit Function

WriteToDatabaseError:

   WriteToDatabase = "Error Description: " & Err.Description & vbCrLf & _
                        "Error Number: " & Err.Number & vbCrLf & _
                           "Error Source: " & Err.Source
   Err.Clear
     GoTo ExitWriteToDatabase

   End Function
   
   Public Function WriteToTextFile(ByVal v_sAppName, ByVal v_sClass, _
                   ByVal v_sMethodProperty, ByVal v_sMessage As String, _
                     ByVal v_eLevel As e_ErrorLevels) As Boolean

   Dim intFileNumber As Integer
   Dim strAppName As String * 15
   Dim strClass As String * 15
   Dim strMethodProperty As String * 15
   Dim strMessage As String * 100
   Dim strLevel As String * 5
   strLevel = Str(v_eLevel)
   strAppName = v_sAppName
   strClass = v_sClass
   strMethodProperty = v_sMethodProperty
   strMessage = v_sMessage
     intFileNumber = FreeFile
     If v_eLevel = Informational Then
     Open "c:\" & v_sAppName & "Log.txt" For Append As #intFileNumber
     Write #intFileNumber, intFileNumber & Chr(34) & _
                           strAppName & Chr(34) & _
                           strClass & Chr(34) & _
                           strMethodProperty & Chr(34) & _
                           strMessage
   Else
      strLevel = Str(v_eLevel)
      Open "c:\" & v_sAppName & "ErrLog.txt" For Append As _
           #intFileNumber
      Write #intFileNumber, intFileNumber & Chr(34) & _
                           strAppName & Chr(34) & _
                           strClass & Chr(34) & _
                           strMethodProperty & Chr(34) & _
                           strMessage & Chr(34) & _
                           strLevel
   End If
   Close #intFileNumber

   End Function
   Public Sub WriteToEventLog(ByVal v_sAppName, ByVal v_sClass, _
       ByVal v_sMethodProperty, ByVal v_sMessage As String, _
       ByVal v_eLevel As e_ErrorLevels)
     If App.LogMode = vbLogAuto Or vbLogToNT Then
        App.Title = v_sAppName
        App.LogEvent v_sMessage & "(" & v_sClass & "/" & v_sAppName & ")", _
             v_eLevel
     Else
        If WriteToDatabase(v_sAppName, v_sClass, v_sMethodProperty, _
           v_sMessage, v_eLevel) <> "" Then
              WriteToTextFile v_sAppName, v_sClass, v_sMethodProperty, _
                 v_sMessage, v_eLevel
     End If
   End If

   End Sub
   Private Function CreateInstance(ProgID As String) As Object
     On Error GoTo CreateInstanceError
     If Not m_objContext Is Nothing Then
       Set CreateInstance = m_objContext.CreateInstance(ProgID)
   Else
      WriteToEventLog App.EXEName, "LogFile", "CreateInstance", "Can not get reference to context", Warning
   Select Case ProgID
     Case "ADODB.Connection"
        Set CreateInstance = New ADODB.Connection
     Case "ADODB.Recordset"
        Set CreateInstance = New ADODB.Recordset
   End Select
   End If

   Exit Function

CreateInstanceError:

      Err.Raise Err.Number, Err.Source & " CreateInstance", Err.Description
   End Function
   Private Sub SetADOConnection(ByVal v_strUserID As String, _
            ByVal v_strPassword As String, _
            Optional ByVal v_sConnectionString As String = "Empty")

     On Error GoTo SetADOConnectionError

     Set m_objADOConnection = CreateInstance("ADODB.Connection")

     With m_objADOConnection
       .CursorLocation = adUseServer
       If v_sConnectionString = "Empty" Then
          .ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
             "Persist Security Info=False;Data Source=" & m_cstrDatabasePath
     Else
       .ConnectionString = v_sConnectionString
     End If
        .Open
     End With
 
    Exit Sub

SetADOConnectionError:

     Dim lngErrorCounter As Long
     Dim strErrors As String

     strErrors = Err.Number & ": " & Err.Description

     If m_objADOConnection.Errors.Count > 0 Then

       For lngErrorCounter = 0 To m_objADOConnection.Errors.Count - 1
            strErrors = strErrors & _
            m_objADOConnection.Errors(lngErrorCounter).Number & _
            ": " & m_objADOConnection.Errors(lngErrorCounter).Description & _
                vbCrLf
     Next lngErrorCounter

     End If
     WriteToTextFile App.EXEName, "LogFile", "SetADOConnection", _
         "Connection Failed", Informational
   End Sub

   Private Function GetADOConnection() As ADODB.Connection
     If m_objADOConnection Is Nothing Then
       Err.Raise 2001, "GetADOConnection", _
         "Trying to Get Connection prior to setting it"
     Else
        Set GetADOConnection = m_objADOConnection

      End If
   End Function
   
   Private Sub CloseADOConnection()
     With GetADOConnection
       If .State = adStateOpen Then
          .Close
     End If

     End With
   End Sub

   Public Function GetRecordset() As ADODB.Recordset
   
      Dim strADOConnection As String
   Dim objCustomersRS As ADODB.Recordset
   On Error GoTo GetRecordsetError

     strADOConnection = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
         "Data Source=" & m_cstrDatabasePath & _
         ";Persist Security Info=False"
   SetADOConnection "", "", strADOConnection
   Set objCustomersRS = New ADODB.Recordset
   objCustomersRS.CursorLocation = adUseClient
   objCustomersRS.CursorType = adOpenStatic
   objCustomersRS.LockType = adLockPessimistic
   objCustomersRS.Source = "Customers"
   Set objCustomersRS.ActiveConnection = GetADOConnection
   objCustomersRS.Open
   Set objCustomersRS.ActiveConnection = Nothing
   Set GetRecordset = objCustomersRS
 
   CloseADOConnection
   Exit Function
GetRecordsetError:
      CloseADOConnection
      Err.Raise Err.Number, Err.Source & " GetRecordset", Err.Description
   End Function

   Public Sub ChangeRecordset(ByVal v_oCustomerRS As ADODB.Recordset)
      v_oCustomerRS.Fields("ContactTitle") = "NewValue"
   End Sub


